/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync;

import com.mojang.authlib.GameProfile;
import dev.upcraft.datasync.api.DataSyncAPI;
import dev.upcraft.datasync.api.SyncToken;
import dev.upcraft.datasync.api.util.Entitlements;
import dev.upcraft.datasync.content.DataStore;
import dev.upcraft.datasync.net.C2SUpdatePlayerDataPacket;
import dev.upcraft.datasync.util.EntitlementsImpl;
import dev.upcraft.datasync.util.ModHelper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSyncMod
implements ModInitializer {
    public static final String MOD_ID = "datasync_minecraft";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)ModHelper.getMeta("datasync_minecraft").getName());
    public static final boolean HAS_INTERNET = DataSyncMod.checkInternetAccess();
    public static final String API_URL = "https://datasync-api.uuid.gg/api";
    public static final class_2960 ENTITLEMENTS_ID = DataSyncMod.dataId("entitlements");
    public static final SyncToken<Entitlements> ENTITLEMENTS_TOKEN = DataSyncAPI.register(Entitlements.class, ENTITLEMENTS_ID, EntitlementsImpl.CODEC);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(Long.getLong("datasync.request.timeout", 6000L));
    public static final boolean LOGIN_AUTOFETCH = !Boolean.getBoolean("datasync.login_autofetch.disable");
    public static final boolean LOGIN_FORCE_REFRESH = Boolean.getBoolean("datasync.login_force_refresh");

    public static class_2960 dataId(String path) {
        return new class_2960("datasync", path);
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public void onInitialize() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (LOGIN_AUTOFETCH) {
                GameProfile profile = handler.method_32311().method_7334();
                DataStore.refresh(profile.getId(), LOGIN_FORCE_REFRESH).thenRunAsync(() -> LOGGER.debug("loaded player data for '{}' ({})", (Object)profile.getName(), (Object)profile.getId()));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(C2SUpdatePlayerDataPacket.TYPE, C2SUpdatePlayerDataPacket::handle);
    }

    private static boolean checkInternetAccess() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://sessionserver.mojang.com")).build();
            client.send(request, HttpResponse.BodyHandlers.discarding());
            return true;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("failed to connect to mojang session server, disabling online features!");
            return false;
        }
    }
}

